/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	SunBeam
**
** DESCRIPTION:	Sun beam effect
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef SUNBEAM_H
#define SUNBEAM_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "ldwImage.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int SunBeam_c_iMaxSunBeams = 64;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CSunBeam
{
private:

	//class structures
	struct SSunBeam
	{
		ldwPoint		m_sPos;
		float			m_fAlpha;
		unsigned int	m_uiFadeOffTime;
		bool			m_bIsFadingOn;
	};

	//class data
	SSunBeam		m_SunBeam[SunBeam_c_iMaxSunBeams];
	ldwImage *		m_pSunBeamImage;

	//class methods
	//setup
	public:		CSunBeam();
	public:		~CSunBeam();
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();

	//process
	public:		void Update();
	public:		void Draw();

	//access
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CSunBeam		SunBeam;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/